/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.timing;

import emulator.EmulatorException;
import emulator.unittest.hardware.nmos6502.timing.TimingTestBase;
import org.junit.Assert;
import org.junit.Test;

public class AbsoluteYTest {
    @Test
    public void testADC() throws EmulatorException {
        int opcode = 121;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testAND() throws EmulatorException {
        int opcode = 57;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testCMP() throws EmulatorException {
        int opcode = 217;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testEOR() throws EmulatorException {
        int opcode = 89;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testLDA() throws EmulatorException {
        int opcode = 185;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testLDX() throws EmulatorException {
        int opcode = 190;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testORA() throws EmulatorException {
        int opcode = 25;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testSBC() throws EmulatorException {
        int opcode = 249;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testSTA() throws EmulatorException {
        int opcode = 153;
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    private int getCycles(int opcode, boolean cross_page) throws EmulatorException {
        TimingTestBase test_base = new TimingTestBase();
        test_base.setRegisters(0, 0, cross_page ? 192 : 0, 0);
        test_base.setCommand(0, opcode, 68, 0);
        test_base.execute();
        return test_base.getElapsedCycles();
    }
}

